<?php


session_start();
if ($_SESSION['unohs'] == null) {
    header("location:index.php?msg=unauthorized");
}
?>
<?php
include ("conn.php");

// Handle test AJAX request
if (isset($_POST['action']) && $_POST['action'] == 'test') {
    echo "Test successful! PHP is receiving POST data correctly.";
    exit;
}

// Handle debug request to show record details
if (isset($_POST['action']) && $_POST['action'] == 'debug_record') {
    header('Content-Type: application/json');
    $withdraw_id = mysqli_real_escape_string($conn, $_POST['withdraw_id']);
    
    $debugQuery = "SELECT * FROM hintegedukolli WHERE shonu = '$withdraw_id'";
    $debugResult = mysqli_query($conn, $debugQuery);
    $record = mysqli_fetch_assoc($debugResult);
    
    echo json_encode([
        'success' => true,
        'withdraw_id_searched' => $withdraw_id,
        'record_found' => $record ? true : false,
        'record_data' => $record,
        'total_records_in_table' => mysqli_num_rows(mysqli_query($conn, "SELECT COUNT(*) as count FROM hintegedukolli WHERE madari = 4"))
    ]);
    exit;
}

// Handle AJAX request for sending withdrawal
if (isset($_POST['action']) && $_POST['action'] == 'send_withdrawal') {
    $withdraw_id = mysqli_real_escape_string($conn, $_POST['withdraw_id']);
    $amount = mysqli_real_escape_string($conn, $_POST['amount']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $order_code = mysqli_real_escape_string($conn, $_POST['order_code']);
    
    // API configuration
    $merchantKey = "vqusxhuW580iP4pEJXR2wrlhS8mdV2tI";
    $usercode = "250614253346";
    $remitUrl = "https://open.rplapi.com/rupeeLink/api/remit";
    $callback_url = "https://vegasclub.live/pay/withdrawal-callback.php";
    
    // Generate signature for remit API
    $signString = $order_code . "&" . $amount . "&" . $address . "&" . $usercode . "&" . $merchantKey;
    $sign = strtoupper(md5($signString));
    
    // Prepare the request payload
    $postData = [
        'userCode' => $usercode,
        'orderCode' => $order_code,
        'amount' => $amount,
        'address' => $address,
        'callbackUrl' => $callback_url,
        'callbackDelayTime' => 5,
        'sign' => $sign,
    ];
    
    // Send the request to the remit API
    $ch = curl_init($remitUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        echo json_encode(['success' => false, 'message' => 'Curl Error: ' . curl_error($ch)]);
    } else {
        $responseData = json_decode($response, true);
        
        if ($responseData && $responseData['code'] == 200) {
            // Update the withdrawal status in database - change sthiti to 1 and tike to completed
            $updateQuery = "UPDATE hintegedukolli SET 
                            sthiti = '1', 
                            tike = 'completed', 
                            remarks = 'Payment sent via API. Order No: " . mysqli_real_escape_string($conn, $responseData['data']['orderNo']) . "' 
                            WHERE shonu = '$withdraw_id'";
            
            $updateResult = mysqli_query($conn, $updateQuery);
            
            if (!$updateResult) {
                // If database update fails, log the error but still return success since API call succeeded
                error_log("Database update failed for withdraw_id: $withdraw_id - " . mysqli_error($conn));
            }
            
            // Also update withdrawal_requests table if exists
            $updateWrQuery = "UPDATE withdrawal_requests SET status = 'completed' WHERE withdraw_id = '$withdraw_id'";
            mysqli_query($conn, $updateWrQuery);
            
            echo json_encode([
                'success' => true, 
                'message' => 'Withdrawal sent successfully and status updated!',
                'orderNo' => $responseData['data']['orderNo'],
                'database_updated' => $updateResult ? true : false
            ]);
        } else {
            echo json_encode([
                'success' => false, 
                'message' => 'API Error: ' . ($responseData['message'] ?? 'Unknown error'),
                'response' => $responseData
            ]);
        }
    }
    
    curl_close($ch);
    exit;
}

// Handle AJAX request for rejecting withdrawal
if (isset($_POST['action']) && $_POST['action'] == 'reject_withdrawal') {
    header('Content-Type: application/json');
    
    // Log all POST data for debugging
    error_log("POST data received: " . print_r($_POST, true));
    
    // Check if withdraw_id key exists in POST data
    if (!isset($_POST['withdraw_id'])) {
        echo json_encode([
            'success' => false, 
            'message' => 'withdraw_id parameter is missing from POST data. Available keys: ' . implode(', ', array_keys($_POST)),
            'debug_info' => 'Missing withdraw_id key',
            'post_data' => $_POST
        ]);
        exit;
    }
    
    $withdraw_id = mysqli_real_escape_string($conn, $_POST['withdraw_id']);
    $reject_reason = isset($_POST['reject_reason']) ? mysqli_real_escape_string($conn, $_POST['reject_reason']) : '';
    
    // Log for debugging
    error_log("Rejecting withdrawal ID: '$withdraw_id', Reason: '$reject_reason'");
    
    // Check if withdraw_id is empty
    if (empty($withdraw_id)) {
        echo json_encode([
            'success' => false, 
            'message' => 'Withdrawal ID is empty. POST data: ' . json_encode($_POST),
            'debug_info' => 'Empty withdraw_id parameter',
            'raw_withdraw_id' => $_POST['withdraw_id'] ?? 'NOT_SET'
        ]);
        exit;
    }
    
    // First, let's check if the record exists
    $checkQuery = "SELECT shonu, sthiti, tike FROM hintegedukolli WHERE shonu = '$withdraw_id'";
    $checkResult = mysqli_query($conn, $checkQuery);
    $recordExists = mysqli_fetch_assoc($checkResult);
    
    if (!$recordExists) {
        echo json_encode([
            'success' => false, 
            'message' => 'Withdrawal ID ' . $withdraw_id . ' not found in database.',
            'debug_info' => 'Record does not exist',
            'search_query' => $checkQuery
        ]);
        exit;
    }
    
    error_log("Found record - Current sthiti: " . $recordExists['sthiti'] . ", tike: " . $recordExists['tike']);
    
    // Check if already processed
    if ($recordExists['sthiti'] == '2' || strtolower($recordExists['tike']) == 'rejected') {
        echo json_encode([
            'success' => false, 
            'message' => 'Withdrawal is already rejected.',
            'debug_info' => 'Already processed'
        ]);
        exit;
    }
    
    if ($recordExists['sthiti'] == '1' || strtolower($recordExists['tike']) == 'completed') {
        echo json_encode([
            'success' => false, 
            'message' => 'Cannot reject a completed withdrawal.',
            'debug_info' => 'Already completed'
        ]);
        exit;
    }
    
    // Update the withdrawal status in database - change sthiti to 2 and tike to rejected
    $updateQuery = "UPDATE hintegedukolli SET 
                    sthiti = '2', 
                    tike = 'rejected', 
                    remarks = 'Withdrawal rejected: " . $reject_reason . "' 
                    WHERE shonu = '$withdraw_id'";
    
    error_log("Executing query: $updateQuery");
    $updateResult = mysqli_query($conn, $updateQuery);
    
    if ($updateResult) {
        $affectedRows = mysqli_affected_rows($conn);
        error_log("Database update result: $affectedRows rows affected");
        
        // Get the withdrawal amount and user ID to refund the amount
        $getWithdrawalDetails = "SELECT motta, balakedara FROM hintegedukolli WHERE shonu = '$withdraw_id'";
        $withdrawalDetailsResult = mysqli_query($conn, $getWithdrawalDetails);
        $withdrawalDetails = mysqli_fetch_assoc($withdrawalDetailsResult);
        
        if ($withdrawalDetails) {
            $refundAmount = $withdrawalDetails['motta'];
            $userId = $withdrawalDetails['balakedara'];
            
            // Add the withdrawal amount back to user's account in shonu_kaichila table
            $refundQuery = "UPDATE shonu_kaichila SET 
                           motta = motta + '$refundAmount' 
                           WHERE balakedara = '$userId'";
            
            error_log("Executing refund query: $refundQuery");
            $refundResult = mysqli_query($conn, $refundQuery);
            
            if ($refundResult) {
                $refundAffectedRows = mysqli_affected_rows($conn);
                error_log("Refund successful: $refundAffectedRows rows affected, Amount: $refundAmount refunded to user: $userId");
            } else {
                error_log("Refund failed: " . mysqli_error($conn));
            }
        }
        
        // Also update withdrawal_requests table if exists - check if balakedara matches
        $updateWrQuery = "UPDATE withdrawal_requests SET status = 'rejected' WHERE withdraw_id = (SELECT balakedara FROM hintegedukolli WHERE shonu = '$withdraw_id')";
        $wrResult = mysqli_query($conn, $updateWrQuery);
        
        if ($affectedRows > 0) {
            $responseMessage = 'Withdrawal rejected successfully!';
            if (isset($refundResult) && $refundResult && isset($refundAffectedRows) && $refundAffectedRows > 0) {
                $responseMessage .= ' Amount ₹' . $refundAmount . ' has been refunded to user account.';
            }
            
            echo json_encode([
                'success' => true, 
                'message' => $responseMessage,
                'database_updated' => true,
                'affected_rows' => $affectedRows,
                'refund_processed' => isset($refundResult) && $refundResult ? true : false,
                'refund_amount' => isset($refundAmount) ? $refundAmount : 0,
                'debug_info' => 'Update successful'
            ]);
        } else {
            echo json_encode([
                'success' => false, 
                'message' => 'No rows updated despite record existing. Check database constraints.',
                'database_updated' => false,
                'affected_rows' => $affectedRows,
                'debug_info' => 'Record exists but no update occurred'
            ]);
        }
    } else {
        $error = mysqli_error($conn);
        error_log("Database error: $error");
        echo json_encode([
            'success' => false, 
            'message' => 'Database update failed: ' . $error,
            'database_updated' => false,
            'debug_info' => 'SQL error'
        ]);
    }
    
    exit;
}

// Query to get records where madari type is 4 and join with withdrawal_requests
$sql = "SELECT h.*, wr.mobile_no as rupeelink_address, wr.beneficiary_name
        FROM hintegedukolli h
        LEFT JOIN withdrawal_requests wr ON h.balakedara = wr.withdraw_id
        WHERE h.madari = 4
        ORDER BY h.dinankavannuracisi DESC";

$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Query failed: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Withdrawal Records - Madari Type 4</title>
    <link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="vendors/feather/feather.css">
    <link rel="stylesheet" href="vendors/base/vendor.bundle.base.css">
    <link rel="stylesheet" href="vendors/flag-icon-css/css/flag-icon.min.css"/>
    <link rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars-o.css">
    <link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.2.3/css/fixedHeader.dataTables.min.css">
    <link rel="shortcut icon" href="images/favicon.png" />
    <style>
        .status-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        .status-applied {
            background-color: #28a745;
            color: white;
        }
        .status-rejected {
            background-color: #dc3545;
            color: white;
        }
        .status-pending {
            background-color: #ffc107;
            color: black;
        }
        .status-sent {
            background-color: #17a2b8;
            color: white;
        }
        .status-completed {
            background-color: #28a745;
            color: white;
        }
        .status-1 {
            background-color: #28a745;
            color: white;
        }
        .status-2 {
            background-color: #dc3545;
            color: white;
        }
        .table-responsive {
            overflow-x: auto;
        }
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-send-withdrawal {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            margin-right: 5px;
        }
        .btn-send-withdrawal:hover {
            background-color: #0056b3;
        }
        .btn-send-withdrawal:disabled {
            background-color: #6c757d;
            cursor: not-allowed;
        }
        .btn-reject-withdrawal {
            background-color: #dc3545;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
        }
        .btn-reject-withdrawal:hover {
            background-color: #c82333;
        }
        .btn-reject-withdrawal:disabled {
            background-color: #6c757d;
            cursor: not-allowed;
        }
        .loading {
            display: none;
        }
        .action-buttons {
            display: flex;
            gap: 5px;
            align-items: center;
        }
        
        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }
        
        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 400px;
            border-radius: 8px;
        }
        
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        
        .close:hover,
        .close:focus {
            color: black;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .form-group textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            resize: vertical;
        }
        
        .modal-buttons {
            text-align: right;
            margin-top: 20px;
        }
        
        .modal-buttons button {
            padding: 8px 16px;
            margin-left: 10px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        
        .btn-modal-cancel {
            background-color: #6c757d;
            color: white;
        }
        
        .btn-modal-confirm {
            background-color: #dc3545;
            color: white;
        }
    </style>
</head>

<body>
    <div class="container-scroller">
        <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
            <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
                <a class="navbar-brand brand-logo" href="dashboard.php"><img src="images/logo.png" alt="logo" /></a>
                <a class="navbar-brand brand-logo-mini" href="dashboard.php"><img src="images/logo-mini.png" alt="logo" /></a>
            </div>
            <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end">
                <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
                    <span class="icon-menu"></span>
                </button>
                <ul class="navbar-nav navbar-nav-right">
                    <li class="nav-item dropdown d-flex mr-4 ">
                        <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown">
                            <i class="icon-cog"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
                            <p class="mb-0 font-weight-normal float-left dropdown-header">Settings</p>
                            <a class="dropdown-item preview-item" href="logout.php">
                                <i class="icon-inbox"></i> Logout
                            </a>
                        </div>
                    </li>
                </ul>
                <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
                    <span class="icon-menu"></span>
                </button>
            </div>
        </nav>
        <div class="container-fluid page-body-wrapper">
            <nav class="sidebar sidebar-offcanvas" id="sidebar">
                <div class="user-profile">
                    <div class="user-image">
                        <img src="images/faces/face28.png">
                    </div>
                    <div class="user-name"></div>
                    <div class="user-designation">
                        Developer
                    </div>
                </div>
                <?php include 'compass.php'; ?>
            </nav>
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Withdrawal Records - Madari Type 4</h4>
                            <p class="card-description">Records where madari type is 4 with user rupeelink addresses</p>
                            <button onclick="testAjax()" class="btn btn-info btn-sm">Test AJAX Connection</button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="withdrawalTable" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>UI</th>
                                            <th>Amount</th>
                                            <th>Order No</th>
                                            <th>Date</th>
                                            <th>Tike</th>
                                            <th>Status</th>
                                            <th>Rupeelink Address</th>
                                            <th>Beneficiary Name</th>
                                            <th>Remarks</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['shonu']); ?></td>
                                            <td><?php echo htmlspecialchars($row['balakedara']); ?></td>
                                            <td>₹<?php echo htmlspecialchars($row['motta']); ?></td>
                                            <td><?php echo htmlspecialchars($row['dharavahi']); ?></td>
                                            <td><?php echo htmlspecialchars($row['dinankavannuracisi']); ?></td>
                                            <td><?php echo htmlspecialchars($row['tike']); ?></td>
                                            <td>
                                                <?php
                                                $status_class = '';
                                                switch(strtolower($row['sthiti'])) {
                                                    case 'applied':
                                                        $status_class = 'status-applied';
                                                        break;
                                                    case 'rejected':
                                                        $status_class = 'status-rejected';
                                                        break;
                                                    case 'pending':
                                                        $status_class = 'status-pending';
                                                        break;
                                                    case 'sent':
                                                        $status_class = 'status-sent';
                                                        break;
                                                    case '1':
                                                        $status_class = 'status-1';
                                                        break;
                                                    case '2':
                                                        $status_class = 'status-2';
                                                        break;
                                                    default:
                                                        $status_class = 'status-pending';
                                                }
                                                ?>
                                                <span class="status-badge <?php echo $status_class; ?>">
                                                    <?php echo htmlspecialchars($row['sthiti']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['rupeelink_address'] ?? 'N/A'); ?></td>
                                            <td><?php echo htmlspecialchars($row['beneficiary_name'] ?? 'N/A'); ?></td>
                                            <td><?php echo htmlspecialchars($row['remarks'] ?? 'N/A'); ?></td>
                                            <td>
                                                <div class="action-buttons">
                                                    <?php if ($row['sthiti'] == '1' || strtolower($row['tike']) == 'completed'): ?>
                                                        <span class="text-success">✓ Completed</span>
                                                    <?php elseif ($row['sthiti'] == '2' || strtolower($row['tike']) == 'rejected'): ?>
                                                        <span class="text-danger">✗ Rejected</span>
                                                    <?php else: ?>
                                                        <?php if ($row['rupeelink_address']): ?>
                                                            <button class="btn-send-withdrawal" 
                                                                    onclick="sendWithdrawal(<?php echo $row['shonu']; ?>, '<?php echo $row['motta']; ?>', '<?php echo $row['rupeelink_address']; ?>', '<?php echo $row['dharavahi']; ?>')"
                                                                    id="btn-send-<?php echo $row['shonu']; ?>">
                                                                Send
                                                            </button>
                                                        <?php else: ?>
                                                            <span class="text-muted">No Address</span>
                                                        <?php endif; ?>
                                                        <button class="btn-reject-withdrawal" 
                                                                onclick="console.log('Button clicked for ID:', <?php echo $row['shonu']; ?>); showRejectModal(<?php echo $row['shonu']; ?>, '<?php echo $row['motta']; ?>')"
                                                                id="btn-reject-<?php echo $row['shonu']; ?>">
                                                            Reject
                                                        </button>
                                                        <button class="btn btn-warning btn-sm" 
                                                                onclick="debugRecord(<?php echo $row['shonu']; ?>)"
                                                                style="font-size: 10px; padding: 2px 5px; margin-left: 5px;">
                                                            Debug
                                                        </button>
                                                    <?php endif; ?>
                                                    <div class="loading" id="loading-<?php echo $row['shonu']; ?>">
                                                        <i class="fa fa-spinner fa-spin"></i> Processing...
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="footer">
                    <div class="d-sm-flex justify-content-center justify-content-sm-between">
                        <span class="text-muted d-block text-center text-sm-left d-sm-inline-block">Copyright © Indo Web Agency</span>
                    </div>
                </footer>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div id="rejectModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeRejectModal()">&times;</span>
            <h3>Reject Withdrawal</h3>
            <p>Are you sure you want to reject this withdrawal?</p>
            <p><strong>Amount:</strong> ₹<span id="rejectAmount"></span></p>
            <div class="form-group">
                <label for="rejectReason">Reason for rejection:</label>
                <textarea id="rejectReason" rows="3" placeholder="Enter reason for rejection..." required></textarea>
            </div>
            <div class="modal-buttons">
                <button class="btn-modal-cancel" onclick="closeRejectModal()">Cancel</button>
                <button class="btn-modal-confirm" onclick="confirmReject()">Reject Withdrawal</button>
            </div>
        </div>
    </div>

    <script src="vendors/base/vendor.bundle.base.js"></script>
    <script src="js/off-canvas.js"></script>
    <script src="js/hoverable-collapse.js"></script>
    <script src="js/template.js"></script>
    <script src="vendors/chart.js/Chart.min.js"></script>
    <script src="vendors/jquery-bar-rating/jquery.barrating.min.js"></script>
    <script src="js/dashboard.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    
    <script>
        let currentRejectId = null;
        
        // Test function to check AJAX connection
        function testAjax() {
            console.log('Testing AJAX connection...');
            $.ajax({
                url: window.location.href,
                method: 'POST',
                data: {
                    action: 'test',
                    test_data: 'hello'
                },
                success: function(response) {
                    console.log('Test response received:', response);
                    alert('AJAX connection working. Response: ' + response);
                },
                error: function(xhr, status, error) {
                    console.log('Test AJAX failed:', {xhr, status, error});
                    alert('AJAX test failed: ' + error);
                }
            });
        }
        
        // Debug function to check record details
        function debugRecord(withdrawId) {
            console.log('Debugging record ID:', withdrawId);
            $.ajax({
                url: window.location.href,
                method: 'POST',
                data: {
                    action: 'debug_record',
                    withdraw_id: withdrawId
                },
                dataType: 'json',
                success: function(response) {
                    console.log('Debug response:', response);
                    let message = 'Debug Info for ID ' + withdrawId + ':\n\n';
                    message += 'Record Found: ' + (response.record_found ? 'Yes' : 'No') + '\n';
                    if (response.record_found) {
                        message += 'Current Status (sthiti): ' + response.record_data.sthiti + '\n';
                        message += 'Current Tike: ' + response.record_data.tike + '\n';
                        message += 'Balakedara: ' + response.record_data.balakedara + '\n';
                        message += 'Motta: ' + response.record_data.motta + '\n';
                        message += 'Full Record: ' + JSON.stringify(response.record_data, null, 2);
                    }
                    alert(message);
                },
                error: function(xhr, status, error) {
                    console.log('Debug AJAX failed:', {xhr, status, error});
                    alert('Debug failed: ' + error);
                }
            });
        }
        
        $(document).ready(function() {
            $('#withdrawalTable').DataTable({
                "pageLength": 25,
                "responsive": true,
                "ordering": true,
                "searching": true,
                "lengthChange": true,
                "info": true,
                "autoWidth": false,
                "order": [[ 4, "desc" ]], // Order by 'Date' column descending (latest first)
                "columnDefs": [
                    { "width": "80px", "targets": 0 },
                    { "width": "120px", "targets": 1 },
                    { "width": "100px", "targets": 2 },
                    { "width": "150px", "targets": 7 }, // Rupeelink Address column
                    { "width": "120px", "targets": 6 }, // Status column
                    { "width": "150px", "targets": 10 } // Actions column
                ]
            });
        });

        function sendWithdrawal(withdrawId, amount, address, orderCode) {
            // Validate inputs
            if (!address || address === 'N/A') {
                alert('No valid address found for this withdrawal');
                return;
            }
            
            if (!confirm('Are you sure you want to send withdrawal of ₹' + amount + ' to ' + address + '?')) {
                return;
            }
            
            // Show loading state
            $('#btn-send-' + withdrawId).hide();
            $('#btn-reject-' + withdrawId).hide();
            $('#loading-' + withdrawId).show();
            
            // Send AJAX request
            $.ajax({
                url: window.location.href,
                method: 'POST',
                data: {
                    action: 'send_withdrawal',
                    withdraw_id: withdrawId,
                    amount: amount,
                    address: address,
                    order_code: orderCode
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert('Withdrawal sent successfully and status updated!\nOrder No: ' + response.orderNo);
                        location.reload(); // Refresh the page to update status
                    } else {
                        alert('Error: ' + response.message);
                        console.log('API Response:', response);
                    }
                },
                error: function(xhr, status, error) {
                    alert('Request failed: ' + error);
                    console.log('Ajax Error:', xhr.responseText);
                },
                complete: function() {
                    // Hide loading state
                    $('#loading-' + withdrawId).hide();
                    $('#btn-send-' + withdrawId).show();
                    $('#btn-reject-' + withdrawId).show();
                }
            });
        }

        function showRejectModal(withdrawId, amount) {
            console.log('showRejectModal called with:', {withdrawId, amount});
            currentRejectId = withdrawId;
            console.log('currentRejectId set to:', currentRejectId);
            $('#rejectAmount').text(amount);
            $('#rejectReason').val('');
            $('#rejectModal').show();
        }

        function closeRejectModal() {
            $('#rejectModal').hide();
            currentRejectId = null;
        }

        function confirmReject() {
            console.log('confirmReject called, currentRejectId:', currentRejectId);
            
            if (!currentRejectId) {
                alert('No withdrawal selected - currentRejectId is: ' + currentRejectId);
                return;
            }
            
            const reason = $('#rejectReason').val().trim();
            if (!reason) {
                alert('Please enter a reason for rejection');
                return;
            }
            
            // Store the ID in a local variable before closing modal
            const withdrawIdToReject = currentRejectId;
            
            console.log('Rejecting withdrawal ID:', withdrawIdToReject, 'Reason:', reason);
            console.log('Data being sent:', {
                action: 'reject_withdrawal',
                withdraw_id: withdrawIdToReject,
                reject_reason: reason
            });
            
            // Show loading state
            $('#btn-send-' + withdrawIdToReject).hide();
            $('#btn-reject-' + withdrawIdToReject).hide();
            $('#loading-' + withdrawIdToReject).show();
            
            // Close modal AFTER storing the ID
            closeRejectModal();
            
            // Send AJAX request
            $.ajax({
                url: window.location.href,
                method: 'POST',
                data: {
                    action: 'reject_withdrawal',
                    withdraw_id: withdrawIdToReject,
                    reject_reason: reason
                },
                dataType: 'json',
                timeout: 30000, // 30 second timeout
                beforeSend: function() {
                    console.log('Sending AJAX request to reject withdrawal ID:', withdrawIdToReject);
                },
                success: function(response) {
                    console.log('Reject response:', response);
                    if (response.success) {
                        alert('Withdrawal rejected successfully!' + 
                              (response.affected_rows ? '\nRows affected: ' + response.affected_rows : ''));
                        location.reload(); // Refresh the page to update status
                    } else {
                        alert('Error: ' + response.message + 
                              (response.debug_info ? '\nDebug: ' + response.debug_info : ''));
                        console.log('API Response:', response);
                        // Show buttons again on error
                        $('#btn-send-' + withdrawIdToReject).show();
                        $('#btn-reject-' + withdrawIdToReject).show();
                    }
                },
                error: function(xhr, status, error) {
                    console.log('Ajax Error Details:', {
                        status: status,
                        error: error,
                        responseText: xhr.responseText,
                        statusCode: xhr.status
                    });
                    
                    let errorMessage = 'Request failed: ' + error;
                    if (xhr.responseText) {
                        try {
                            const errorResponse = JSON.parse(xhr.responseText);
                            errorMessage = 'Error: ' + errorResponse.message;
                        } catch (e) {
                            // If response is not JSON, show the raw response
                            errorMessage = 'Server Error: ' + xhr.responseText.substring(0, 200);
                        }
                    }
                    
                    alert(errorMessage);
                    // Show buttons again on error
                    $('#btn-send-' + withdrawIdToReject).show();
                    $('#btn-reject-' + withdrawIdToReject).show();
                },
                complete: function() {
                    // Hide loading state
                    $('#loading-' + withdrawIdToReject).hide();
                }
            });
        }

        // Close modal when clicking outside of it
        window.onclick = function(event) {
            const modal = document.getElementById('rejectModal');
            if (event.target == modal) {
                closeRejectModal();
            }
        }

        if (window.history.replaceState) {
            window.history.replaceState(null, null, window.location.href);
        }
    </script>
</body>

</html>
